<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_configuration', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->string('name')->unique();
            $table->string('type');
            $table->longText('value')->nullable();
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });

        $date = Carbon::now();

        DB::table('system_configuration')->insert([
            'key' => 'application_name',
            'name' => 'Nombre de la institución',
            'type' => 'string',
            'value' => null,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        DB::table('system_configuration')->insert([
            'key' => 'support_emails',
            'name' => 'Correos de soporte',
            'type' => 'array',
            'value' => null,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        DB::table('system_configuration')->insert([
            'key' => 'logo',
            'name' => 'Logo',
            'type' => 'string',
            'value' => null,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        DB::table('system_configuration')->insert([
            'key' => 'favicon',
            'name' => 'Favicon',
            'type' => 'string',
            'value' => null,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        DB::table('system_configuration')->insert([
            'key' => 'banner',
            'name' => 'Banner',
            'type' => 'string',
            'value' => null,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        DB::table('system_configuration')->insert([
            'key' => 'maximum_file_size_to_upload',
            'name' => 'Tamaño máximo de archivos a subir (MB)',
            'type' => 'number',
            'value' => 2,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        DB::table('system_configuration')->insert([
            'key' => 'extensions_allowed_to_upload',
            'name' => 'Extensiones permitidas para subir archivos',
            'type' => 'array',
            'value' => json_encode([
                ["extension" => "pdf", "permitted" => true],
                ["extension" => "doc", "permitted" => true],
                ["extension" => "docx", "permitted" => true],
                ["extension" => "xls", "permitted" => true],
                ["extension" => "xlsx", "permitted" => true],
                ["extension" => "ppt", "permitted" => true],
                ["extension" => "pptx", "permitted" => true],

                ["extension" => "zip", "permitted" => true],
                ["extension" => "rar", "permitted" => true],

                ["extension" => "jpg", "permitted" => true],
                ["extension" => "jpeg", "permitted" => true],
                ["extension" => "png", "permitted" => true],
                ["extension" => "gif", "permitted" => true],

                ["extension" => "mp3", "permitted" => true],

                ["extension" => "mp4", "permitted" => true],
                ["extension" => "avi", "permitted" => true],
                ["extension" => "mkv", "permitted" => true],
            ]),
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        DB::table('system_configuration')->insert([
            'key' => 'primary_color',
            'name' => 'Color Primario',
            'type' => 'string',
            'value' => '#7367F0',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_configuration');
    }
};
