<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rol', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('key')->nullable();
            $table->integer('level')->default(1);
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });

        Schema::create('user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')
                ->nullable()
                ->constrained('job_opportunity_company')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('person_id')
                ->nullable()
                ->references('id')
                ->on('person')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('rol_id')
                ->nullable()
                ->references('id')
                ->on('rol')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->string('email')->unique();
            $table->string('password');
            $table->rememberToken();
            $table->string('reset_password_token')->nullable();
            $table->boolean('is_active')->default(true);
            $table->dateTime('last_login')->nullable();
            $table->text('avatar')->nullable();
            $table->unsignedSmallInteger('attempts')->default(0);
            $table->dateTime('last_attempt')->nullable();
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });

        Schema::create('rol_user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rol_id')
                ->references('id')
                ->on('rol')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('user_id')
                ->references('id')
                ->on('user')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });

        Schema::create('menu', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });

        Schema::create('option', function (Blueprint $table) {
            $table->id();
            $table->foreignId('option_id')
                ->nullable()
                ->references('id')
                ->on('option')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('menu_id')
                ->references('id')
                ->on('menu')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->string('name');
            $table->string('name_url');
            $table->string('icon')->nullable();
            $table->boolean('is_visible')->default(true);
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });

        Schema::create('rol_option', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rol_id')
                ->references('id')
                ->on('rol')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('option_id')
                ->references('id')
                ->on('option')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });

        $date = Carbon::now();

        // initial roles
        $rol_id_admin = DB::table('rol')->insertGetId([
            'id' => 1,
            'name' => 'ADMINISTRADOR',
            'key' => 'rol_admin',
            'level' => 1,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $rol_id_teacher = DB::table('rol')->insertGetId([
            'id' => 2,
            'name' => 'DOCENTE',
            'key' => 'rol_teacher',
            'level' => 1,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $rol_id_student = DB::table('rol')->insertGetId([
            'id' => 3,
            'name' => 'ESTUDIANTE',
            'key' => 'rol_student',
            'level' => 1,
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $rol_id_company = DB::table('rol')->insertGetId([
            'id' => 4,
            'name' => 'EMPRESA',
            'key' => 'rol_company',
            'level' => 1,
            'created_at' => $date,
            'updated_at' => $date,
        ]);

        // menus
        $menu_id_principal = DB::table('menu')->insertGetId([
            'name' => 'Principal',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $menu_id_aula_virtual = DB::table('menu')->insertGetId([
            'name' => 'Aula virtual',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $menu_id_preferencias = DB::table('menu')->insertGetId([
            'name' => 'Preferencias',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $menu_id_configuration = DB::table('menu')->insertGetId([
            'name' => 'Configuración',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $menu_id_quick_access = DB::table('menu')->insertGetId([
            'name' => 'Acceso rápido',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $menu_id_bolsa_laboral = DB::table('menu')->insertGetId([
            'name' => 'Bolsa Laboral',
            'created_at' => $date,
            'updated_at' => $date,
        ]);

        // options
        $option_id_home = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_principal,
            'name' => 'Inicio',
            'name_url' => 'Home',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $option_id_settings = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_preferencias,
            'name' => 'Ajustes',
            'name_url' => 'Settings',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $option_id_users = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_configuration,
            'name' => 'Usuarios',
            'name_url' => 'UsersList',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $option_id_profile = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_quick_access,
            'name' => 'Mi Perfil',
            'name_url' => 'Profile',
            'created_at' => $date,
            'updated_at' => $date,
        ]);

        $option_id_offers = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_bolsa_laboral,
            'name' => 'Convocatorias',
            'name_url' => 'Offers',
            'created_at' => $date,
            'updated_at' => $date,
        ]);

        $option_id_companies = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_bolsa_laboral,
            'name' => 'Empresas',
            'name_url' => 'Companies',
            'created_at' => $date,
            'updated_at' => $date,
        ]);

        $option_id_postulaciones = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_bolsa_laboral,
            'name' => 'Postulaciones',
            'name_url' => 'Applications',
            'created_at' => $date,
            'updated_at' => $date,
        ]);

        $option_id_candidate = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_bolsa_laboral,
            'name' => 'Candidato',
            'name_url' => 'Candidate',
            'created_at' => $date,
            'updated_at' => $date,
        ]);

        $option_id_maintainers = DB::table('option')->insertGetId([
            'menu_id' => $menu_id_bolsa_laboral,
            'name' => 'Mantenedores',
            'name_url' => 'JobMaintainers',
            'created_at' => $date,
            'updated_at' => $date,
        ]);

        // roles options
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_teacher,
            'option_id' => $option_id_home,
        ]);
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_teacher,
            'option_id' => $option_id_profile,
        ]);

        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_student,
            'option_id' => $option_id_home,
        ]);
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_student,
            'option_id' => $option_id_profile,
        ]);

        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_admin,
            'option_id' => $option_id_home,
        ]);
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_admin,
            'option_id' => $option_id_settings,
        ]);
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_admin,
            'option_id' => $option_id_users,
        ]);
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_admin,
            'option_id' => $option_id_profile,
        ]);

        // creacion de rol_option para el rol administrador
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_admin,
            'option_id' => $option_id_companies,
        ]);

        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_admin,
            'option_id' => $option_id_offers,
        ]);

        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_admin,
            'option_id' => $option_id_postulaciones,
        ]);

        // creacion de rol_option para el rol de empresa
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_company,
            'option_id' => 1, // home
        ]);

        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_company,
            'option_id' => $option_id_offers,
        ]);

        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_company,
            'option_id' => $option_id_postulaciones,
        ]);

        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_admin,
            'option_id' => $option_id_maintainers,
        ]);

        // creacion de rol_option para el rol de estudiante
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_student,
            'option_id' => $option_id_candidate,
        ]);

        // creacion de rol_option para el rol de docente
        DB::table('rol_option')->insert([
            'rol_id' => $rol_id_teacher,
            'option_id' => $option_id_candidate,
        ]);

        // Inital admin user
        $person_id = DB::table('person')->insertGetId([
            'names' => 'Usuario administrador',
            'document_type' => 'DNI',
            'document_number' => '00000000',
            'phone' => '999999999',
            'email' => 'admin@andheuris.com',
        ]);
        $user_person_id = DB::table('user')->insertGetId([
            'company_id' => null,
            'person_id' => $person_id,
            'rol_id' => $rol_id_admin,
            'email' => 'admin@andheuris.com',
            'password' => bcrypt('admin'),
        ]);
        DB::table('rol_user')->insert([
            'rol_id' => $rol_id_admin,
            'user_id' => $user_person_id,
        ]);
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rol_user');
        Schema::dropIfExists('user');
        Schema::dropIfExists('rol_option');
        Schema::dropIfExists('rol');
        Schema::dropIfExists('option');
        Schema::dropIfExists('menu');
    }
};
