<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('job_opportunity_contract_types', function (Blueprint $table) {
      $table->id();
      $table->string('name');
      $table->dateTime('created_at')->nullable();
      $table->dateTime('updated_at')->nullable();
      $table->dateTime('deleted_at')->nullable();
    });

    DB::table('job_opportunity_contract_types')->insert([
      ['name' => 'Contrato a plazo indeterminado', 'created_at' => now(), 'updated_at' => now()],
      ['name' => 'Contrato a plazo fijo', 'created_at' => now(), 'updated_at' => now()],
      ['name' => 'Contrato por temporada', 'created_at' => now(), 'updated_at' => now()],
    ]);
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('job_opportunity_contract_types');
  }
};
