<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $date = Carbon::now();

        // Teacher user
        $rol_id_teacher = DB::table('rol')->where('key', 'rol_teacher')->value('id');
        $person_teacher_id = DB::table('person')->insertGetId([
            'names' => 'Usuario docente',
            'document_type' => 'DNI',
            'document_number' => '00000001',
            'phone' => '999999999',
            'email' => 'profesor@andheuris.com',
        ]);
        $user_teacher_id = DB::table('user')->insertGetId([
            'company_id' => null,
            'person_id' => $person_teacher_id,
            'rol_id' => $rol_id_teacher,
            'email' => 'profesor@andheuris.com',
            'password' => bcrypt('profesor'),
        ]);
        DB::table('rol_user')->insert([
            'rol_id' => $rol_id_teacher,
            'user_id' => $user_teacher_id,
        ]);

        // Student user
        $rol_id_student = DB::table('rol')->where('key', 'rol_student')->value('id');
        $person_student_id = DB::table('person')->insertGetId([
            'names' => 'Usuario estudiante',
            'document_type' => 'DNI',
            'document_number' => '00000002',
            'phone' => '999999999',
            'email' => 'estudiante@andheuris.com',
        ]);
        $user_student_id = DB::table('user')->insertGetId([
            'company_id' => null,
            'person_id' => $person_student_id,
            'rol_id' => $rol_id_student,
            'email' => 'estudiante@andheuris.com',
            'password' => bcrypt('estudiante'),
        ]);
        DB::table('rol_user')->insert([
            'rol_id' => $rol_id_student,
            'user_id' => $user_student_id,
        ]);

        // Company user
        $rol_id_admin = DB::table('rol')->where('key', 'rol_admin')->value('id');
        $rol_id_company = DB::table('rol')->where('key', 'rol_company')->value('id');
        $company_id = DB::table('job_opportunity_company')->insertGetId([
            'name' => 'Andheuris',
            'ruc' => '00000000',
            'email' => 'andheuris@andheuris.com',
            'phone' => '999999999',
            'mailbox' => 'andheuris@andheuris.com',
            'created_at' => $date,
            'updated_at' => $date,
        ]);
        $person_company_id = DB::table('person')->insertGetId([
            'names' => 'Andheuris',
            'document_type' => 'RUC',
            'document_number' => '00000000',
            'phone' => '999999999',
            'email' => 'andheuris@andheuris.com',
        ]);
        $user_company_id = DB::table('user')->insertGetId([
            'company_id' => $company_id,
            'person_id' => $person_company_id,
            'rol_id' => $rol_id_admin,
            'email' => 'andheuris@andheuris.com',
            'password' => bcrypt('andheuris'),
        ]);
        DB::table('rol_user')->insert([
            'rol_id' => $rol_id_company,
            'user_id' => $user_company_id,
        ]);
    }
}
