/*
 Navicat Premium Data Transfer

 Source Server         : Local WSL
 Source Server Type    : MySQL
 Source Server Version : 80042 (8.0.42-0ubuntu0.22.04.1)
 Source Host           : 172.27.165.235:3306
 Source Schema         : bolsa_laboral

 Target Server Type    : MySQL
 Target Server Version : 80042 (8.0.42-0ubuntu0.22.04.1)
 File Encoding         : 65001

 Date: 03/06/2025 09:58:38
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for cache
-- ----------------------------
DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache`  (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cache
-- ----------------------------

-- ----------------------------
-- Table structure for cache_locks
-- ----------------------------
DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE `cache_locks`  (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cache_locks
-- ----------------------------

-- ----------------------------
-- Table structure for failed_jobs
-- ----------------------------
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `failed_jobs_uuid_unique`(`uuid` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of failed_jobs
-- ----------------------------

-- ----------------------------
-- Table structure for file
-- ----------------------------
DROP TABLE IF EXISTS `file`;
CREATE TABLE `file`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `fileable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileable_id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` json NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `file_fileable_type_fileable_id_index`(`fileable_type` ASC, `fileable_id` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of file
-- ----------------------------

-- ----------------------------
-- Table structure for job_opportunity_applications
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_applications`;
CREATE TABLE `job_opportunity_applications`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `fullname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `program_study` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'postulated',
  `cv` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `feedback` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `feedback_date` datetime NULL DEFAULT NULL,
  `offer_id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `job_opportunity_applications_offer_id_foreign`(`offer_id` ASC) USING BTREE,
  INDEX `job_opportunity_applications_user_id_foreign`(`user_id` ASC) USING BTREE,
  CONSTRAINT `job_opportunity_applications_offer_id_foreign` FOREIGN KEY (`offer_id`) REFERENCES `job_opportunity_offer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_opportunity_applications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_applications
-- ----------------------------

-- ----------------------------
-- Table structure for job_opportunity_company
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_company`;
CREATE TABLE `job_opportunity_company`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mailbox` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_verified` tinyint(1) NOT NULL DEFAULT 0,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `job_opportunity_company_ruc_unique`(`ruc` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_company
-- ----------------------------

-- ----------------------------
-- Table structure for job_opportunity_contract_types
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_contract_types`;
CREATE TABLE `job_opportunity_contract_types`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_contract_types
-- ----------------------------
INSERT INTO `job_opportunity_contract_types` VALUES (1, 'Contrato a plazo indeterminado', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_contract_types` VALUES (2, 'Contrato a plazo fijo', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_contract_types` VALUES (3, 'Contrato por temporada', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);

-- ----------------------------
-- Table structure for job_opportunity_location
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_location`;
CREATE TABLE `job_opportunity_location`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_location
-- ----------------------------
INSERT INTO `job_opportunity_location` VALUES (1, 'Remoto', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_location` VALUES (2, 'Presencial', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_location` VALUES (3, 'Híbrido', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);

-- ----------------------------
-- Table structure for job_opportunity_offer
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_offer`;
CREATE TABLE `job_opportunity_offer`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `requirements` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `publication_date` datetime NOT NULL,
  `deadline` datetime NULL DEFAULT NULL,
  `benefits` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `salary` decimal(10, 2) NOT NULL,
  `salary_currency` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachments` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `company_id` bigint UNSIGNED NOT NULL,
  `location_id` bigint UNSIGNED NOT NULL,
  `state_id` bigint UNSIGNED NOT NULL,
  `category_id` bigint UNSIGNED NOT NULL,
  `work_schedule_id` bigint UNSIGNED NOT NULL,
  `contract_type_id` bigint UNSIGNED NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `job_opportunity_offer_slug_unique`(`slug` ASC) USING BTREE,
  INDEX `job_opportunity_offer_company_id_foreign`(`company_id` ASC) USING BTREE,
  INDEX `job_opportunity_offer_location_id_foreign`(`location_id` ASC) USING BTREE,
  INDEX `job_opportunity_offer_state_id_foreign`(`state_id` ASC) USING BTREE,
  INDEX `job_opportunity_offer_category_id_foreign`(`category_id` ASC) USING BTREE,
  INDEX `job_opportunity_offer_work_schedule_id_foreign`(`work_schedule_id` ASC) USING BTREE,
  INDEX `job_opportunity_offer_contract_type_id_foreign`(`contract_type_id` ASC) USING BTREE,
  CONSTRAINT `job_opportunity_offer_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `job_opportunity_offer_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_opportunity_offer_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `job_opportunity_company` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_opportunity_offer_contract_type_id_foreign` FOREIGN KEY (`contract_type_id`) REFERENCES `job_opportunity_contract_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_opportunity_offer_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `job_opportunity_location` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_opportunity_offer_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `job_opportunity_offer_state` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_opportunity_offer_work_schedule_id_foreign` FOREIGN KEY (`work_schedule_id`) REFERENCES `job_opportunity_work_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_offer
-- ----------------------------

-- ----------------------------
-- Table structure for job_opportunity_offer_category
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_offer_category`;
CREATE TABLE `job_opportunity_offer_category`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_offer_category
-- ----------------------------
INSERT INTO `job_opportunity_offer_category` VALUES (1, 'Informatica/Tecnologia', NULL, '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_offer_category` VALUES (2, 'Marketing', NULL, '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_offer_category` VALUES (3, 'Administrativo', NULL, '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);

-- ----------------------------
-- Table structure for job_opportunity_offer_state
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_offer_state`;
CREATE TABLE `job_opportunity_offer_state`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_offer_state
-- ----------------------------
INSERT INTO `job_opportunity_offer_state` VALUES (1, 'Borrador', 'draft', NULL, '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_offer_state` VALUES (2, 'Vigente', 'active', NULL, '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_offer_state` VALUES (3, 'Finalizada', 'finished', NULL, '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_offer_state` VALUES (4, 'Suspendida', 'suspended', NULL, '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_offer_state` VALUES (5, 'Cancelada', 'canceled', NULL, '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);

-- ----------------------------
-- Table structure for job_opportunity_offer_state_detail
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_offer_state_detail`;
CREATE TABLE `job_opportunity_offer_state_detail`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `offer_id` bigint UNSIGNED NOT NULL,
  `state_id` bigint UNSIGNED NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `job_opportunity_offer_state_detail_offer_id_foreign`(`offer_id` ASC) USING BTREE,
  INDEX `job_opportunity_offer_state_detail_state_id_foreign`(`state_id` ASC) USING BTREE,
  CONSTRAINT `job_opportunity_offer_state_detail_offer_id_foreign` FOREIGN KEY (`offer_id`) REFERENCES `job_opportunity_offer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_opportunity_offer_state_detail_state_id_foreign` FOREIGN KEY (`state_id`) REFERENCES `job_opportunity_offer_state` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_offer_state_detail
-- ----------------------------

-- ----------------------------
-- Table structure for job_opportunity_user_cv
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_user_cv`;
CREATE TABLE `job_opportunity_user_cv`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `job_opportunity_user_cv_user_id_foreign`(`user_id` ASC) USING BTREE,
  CONSTRAINT `job_opportunity_user_cv_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_user_cv
-- ----------------------------

-- ----------------------------
-- Table structure for job_opportunity_work_schedules
-- ----------------------------
DROP TABLE IF EXISTS `job_opportunity_work_schedules`;
CREATE TABLE `job_opportunity_work_schedules`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of job_opportunity_work_schedules
-- ----------------------------
INSERT INTO `job_opportunity_work_schedules` VALUES (1, 'Jornada Completa', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_work_schedules` VALUES (2, 'Becas/Prácticas', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_work_schedules` VALUES (3, 'Jornada Parcial', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);
INSERT INTO `job_opportunity_work_schedules` VALUES (4, 'Por Horas', '2025-06-03 09:58:30', '2025-06-03 09:58:30', NULL);

-- ----------------------------
-- Table structure for jobs
-- ----------------------------
DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint UNSIGNED NOT NULL,
  `reserved_at` int UNSIGNED NULL DEFAULT NULL,
  `available_at` int UNSIGNED NOT NULL,
  `created_at` int UNSIGNED NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `jobs_queue_index`(`queue` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of jobs
-- ----------------------------

-- ----------------------------
-- Table structure for link
-- ----------------------------
DROP TABLE IF EXISTS `link`;
CREATE TABLE `link`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `linkable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `linkable_id` bigint UNSIGNED NOT NULL,
  `url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `link_linkable_type_linkable_id_index`(`linkable_type` ASC, `linkable_id` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of link
-- ----------------------------

-- ----------------------------
-- Table structure for menu
-- ----------------------------
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of menu
-- ----------------------------
INSERT INTO `menu` VALUES (1, 'Principal', '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `menu` VALUES (2, 'Aula virtual', '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `menu` VALUES (3, 'Preferencias', '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `menu` VALUES (4, 'Configuración', '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `menu` VALUES (5, 'Acceso rápido', '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `menu` VALUES (6, 'Bolsa Laboral', '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);

-- ----------------------------
-- Table structure for migrations
-- ----------------------------
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations`  (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 19 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of migrations
-- ----------------------------
INSERT INTO `migrations` VALUES (1, '2024_04_08_145119_create_job_opportunity_company_table', 1);
INSERT INTO `migrations` VALUES (2, '2024_04_08_145119_create_person_table', 1);
INSERT INTO `migrations` VALUES (3, '2024_04_08_145119_create_system_configuration_table', 1);
INSERT INTO `migrations` VALUES (4, '2024_04_08_145120_create_user_table', 1);
INSERT INTO `migrations` VALUES (5, '2024_04_08_231525_create_file_table', 1);
INSERT INTO `migrations` VALUES (6, '2024_04_08_231525_create_link_table', 1);
INSERT INTO `migrations` VALUES (7, '2024_05_15_104107_create_cache_table', 1);
INSERT INTO `migrations` VALUES (8, '2024_05_15_110412_create_jobs_table', 1);
INSERT INTO `migrations` VALUES (9, '2024_05_15_151348_create_failed_jobs_table', 1);
INSERT INTO `migrations` VALUES (10, '2025_05_14_114152_create_job_opportunity_location_table', 1);
INSERT INTO `migrations` VALUES (11, '2025_05_14_114620_create_job_opportunity_offer_state_table', 1);
INSERT INTO `migrations` VALUES (12, '2025_05_14_114758_create_job_opportunity_offer_category_table', 1);
INSERT INTO `migrations` VALUES (13, '2025_05_14_114918_create_job_opportunity_user_cv_table', 1);
INSERT INTO `migrations` VALUES (14, '2025_05_14_115118_create_job_opportunity_work_schedules_table', 1);
INSERT INTO `migrations` VALUES (15, '2025_05_14_115135_create_job_opportunity_contract_types_table', 1);
INSERT INTO `migrations` VALUES (16, '2025_05_14_115138_create_job_opportunity_offer_table', 1);
INSERT INTO `migrations` VALUES (17, '2025_05_14_115139_create_job_opportunity_offer_state_detail_table', 1);
INSERT INTO `migrations` VALUES (18, '2025_05_14_115140_create_job_opportunity_applications_table', 1);

-- ----------------------------
-- Table structure for option
-- ----------------------------
DROP TABLE IF EXISTS `option`;
CREATE TABLE `option`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `option_id` bigint UNSIGNED NULL DEFAULT NULL,
  `menu_id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `is_visible` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `option_option_id_foreign`(`option_id` ASC) USING BTREE,
  INDEX `option_menu_id_foreign`(`menu_id` ASC) USING BTREE,
  CONSTRAINT `option_menu_id_foreign` FOREIGN KEY (`menu_id`) REFERENCES `menu` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `option_option_id_foreign` FOREIGN KEY (`option_id`) REFERENCES `option` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of option
-- ----------------------------
INSERT INTO `option` VALUES (1, NULL, 1, 'Inicio', 'Home', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `option` VALUES (2, NULL, 3, 'Ajustes', 'Settings', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `option` VALUES (3, NULL, 4, 'Usuarios', 'UsersList', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `option` VALUES (4, NULL, 5, 'Mi Perfil', 'Profile', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `option` VALUES (5, NULL, 6, 'Convocatorias', 'Offers', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `option` VALUES (6, NULL, 6, 'Empresas', 'Companies', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `option` VALUES (7, NULL, 6, 'Postulaciones', 'Applications', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `option` VALUES (8, NULL, 6, 'Candidato', 'Candidate', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `option` VALUES (9, NULL, 6, 'Mantenedores', 'JobMaintainers', NULL, 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);

-- ----------------------------
-- Table structure for person
-- ----------------------------
DROP TABLE IF EXISTS `person`;
CREATE TABLE `person`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `document_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `names` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sex` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `birth_date` date NULL DEFAULT NULL,
  `native_language` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of person
-- ----------------------------
INSERT INTO `person` VALUES (1, 'DNI', '00000000', 'Usuario administrador', '999999999', 'admin@andheuris.com', NULL, NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for rol
-- ----------------------------
DROP TABLE IF EXISTS `rol`;
CREATE TABLE `rol`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `level` int NOT NULL DEFAULT 1,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of rol
-- ----------------------------
INSERT INTO `rol` VALUES (1, 'ADMINISTRADOR', 'rol_admin', 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `rol` VALUES (2, 'DOCENTE', 'rol_teacher', 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `rol` VALUES (3, 'ESTUDIANTE', 'rol_student', 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);
INSERT INTO `rol` VALUES (4, 'EMPRESA', 'rol_company', 1, '2025-06-03 09:58:29', '2025-06-03 09:58:29', NULL);

-- ----------------------------
-- Table structure for rol_option
-- ----------------------------
DROP TABLE IF EXISTS `rol_option`;
CREATE TABLE `rol_option`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `rol_id` bigint UNSIGNED NOT NULL,
  `option_id` bigint UNSIGNED NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `rol_option_rol_id_foreign`(`rol_id` ASC) USING BTREE,
  INDEX `rol_option_option_id_foreign`(`option_id` ASC) USING BTREE,
  CONSTRAINT `rol_option_option_id_foreign` FOREIGN KEY (`option_id`) REFERENCES `option` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `rol_option_rol_id_foreign` FOREIGN KEY (`rol_id`) REFERENCES `rol` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 18 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of rol_option
-- ----------------------------
INSERT INTO `rol_option` VALUES (1, 2, 1);
INSERT INTO `rol_option` VALUES (2, 2, 4);
INSERT INTO `rol_option` VALUES (3, 3, 1);
INSERT INTO `rol_option` VALUES (4, 3, 4);
INSERT INTO `rol_option` VALUES (5, 1, 1);
INSERT INTO `rol_option` VALUES (6, 1, 2);
INSERT INTO `rol_option` VALUES (7, 1, 3);
INSERT INTO `rol_option` VALUES (8, 1, 4);
INSERT INTO `rol_option` VALUES (9, 1, 6);
INSERT INTO `rol_option` VALUES (10, 1, 5);
INSERT INTO `rol_option` VALUES (11, 1, 7);
INSERT INTO `rol_option` VALUES (12, 4, 1);
INSERT INTO `rol_option` VALUES (13, 4, 5);
INSERT INTO `rol_option` VALUES (14, 4, 7);
INSERT INTO `rol_option` VALUES (15, 1, 9);
INSERT INTO `rol_option` VALUES (16, 3, 8);
INSERT INTO `rol_option` VALUES (17, 2, 8);

-- ----------------------------
-- Table structure for rol_user
-- ----------------------------
DROP TABLE IF EXISTS `rol_user`;
CREATE TABLE `rol_user`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `rol_id` bigint UNSIGNED NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `rol_user_rol_id_foreign`(`rol_id` ASC) USING BTREE,
  INDEX `rol_user_user_id_foreign`(`user_id` ASC) USING BTREE,
  CONSTRAINT `rol_user_rol_id_foreign` FOREIGN KEY (`rol_id`) REFERENCES `rol` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `rol_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of rol_user
-- ----------------------------
INSERT INTO `rol_user` VALUES (1, 1, 1);

-- ----------------------------
-- Table structure for system_configuration
-- ----------------------------
DROP TABLE IF EXISTS `system_configuration`;
CREATE TABLE `system_configuration`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `system_configuration_key_unique`(`key` ASC) USING BTREE,
  UNIQUE INDEX `system_configuration_name_unique`(`name` ASC) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_configuration
-- ----------------------------
INSERT INTO `system_configuration` VALUES (1, 'application_name', 'Nombre de la institución', 'string', NULL, '2025-06-03 09:58:28', '2025-06-03 09:58:28', NULL);
INSERT INTO `system_configuration` VALUES (2, 'support_emails', 'Correos de soporte', 'array', NULL, '2025-06-03 09:58:28', '2025-06-03 09:58:28', NULL);
INSERT INTO `system_configuration` VALUES (3, 'logo', 'Logo', 'string', NULL, '2025-06-03 09:58:28', '2025-06-03 09:58:28', NULL);
INSERT INTO `system_configuration` VALUES (4, 'favicon', 'Favicon', 'string', NULL, '2025-06-03 09:58:28', '2025-06-03 09:58:28', NULL);
INSERT INTO `system_configuration` VALUES (5, 'banner', 'Banner', 'string', NULL, '2025-06-03 09:58:28', '2025-06-03 09:58:28', NULL);
INSERT INTO `system_configuration` VALUES (6, 'maximum_file_size_to_upload', 'Tamaño máximo de archivos a subir (MB)', 'number', '2', '2025-06-03 09:58:28', '2025-06-03 09:58:28', NULL);
INSERT INTO `system_configuration` VALUES (7, 'extensions_allowed_to_upload', 'Extensiones permitidas para subir archivos', 'array', '[{\"extension\":\"pdf\",\"permitted\":true},{\"extension\":\"doc\",\"permitted\":true},{\"extension\":\"docx\",\"permitted\":true},{\"extension\":\"xls\",\"permitted\":true},{\"extension\":\"xlsx\",\"permitted\":true},{\"extension\":\"ppt\",\"permitted\":true},{\"extension\":\"pptx\",\"permitted\":true},{\"extension\":\"zip\",\"permitted\":true},{\"extension\":\"rar\",\"permitted\":true},{\"extension\":\"jpg\",\"permitted\":true},{\"extension\":\"jpeg\",\"permitted\":true},{\"extension\":\"png\",\"permitted\":true},{\"extension\":\"gif\",\"permitted\":true},{\"extension\":\"mp3\",\"permitted\":true},{\"extension\":\"mp4\",\"permitted\":true},{\"extension\":\"avi\",\"permitted\":true},{\"extension\":\"mkv\",\"permitted\":true}]', '2025-06-03 09:58:28', '2025-06-03 09:58:28', NULL);
INSERT INTO `system_configuration` VALUES (8, 'primary_color', 'Color Primario', 'string', '#7367F0', '2025-06-03 09:58:28', '2025-06-03 09:58:28', NULL);

-- ----------------------------
-- Table structure for user
-- ----------------------------
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `company_id` bigint UNSIGNED NULL DEFAULT NULL,
  `person_id` bigint UNSIGNED NULL DEFAULT NULL,
  `rol_id` bigint UNSIGNED NULL DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `reset_password_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `last_login` datetime NULL DEFAULT NULL,
  `avatar` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `attempts` smallint UNSIGNED NOT NULL DEFAULT 0,
  `last_attempt` datetime NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `user_email_unique`(`email` ASC) USING BTREE,
  INDEX `user_company_id_foreign`(`company_id` ASC) USING BTREE,
  INDEX `user_person_id_foreign`(`person_id` ASC) USING BTREE,
  INDEX `user_rol_id_foreign`(`rol_id` ASC) USING BTREE,
  CONSTRAINT `user_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `job_opportunity_company` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `person` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_rol_id_foreign` FOREIGN KEY (`rol_id`) REFERENCES `rol` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user
-- ----------------------------
INSERT INTO `user` VALUES (1, NULL, 1, 1, 'admin@andheuris.com', '$2y$12$RlzIesMEXbYvGeFkd5HuduiwEPcFhy4Ckho/u./QHPhXhYGbCxDAe', NULL, NULL, 1, NULL, NULL, 0, NULL, NULL, NULL, NULL);

SET FOREIGN_KEY_CHECKS = 1;
