#!/bin/bash

set -e

# Actualizar sistema
sudo apt update 

# Instalar utilidades básicas
sudo apt install -y curl unzip software-properties-common

# Instalar PHP 8.3 y extensiones comunes
sudo add-apt-repository ppa:ondrej/php -y
sudo apt update
sudo apt install -y php8.3 php8.3-cli php8.3-fpm php8.3-mysql php8.3-xml php8.3-mbstring php8.3-curl php8.3-zip php8.3-gd php8.3-bcmath php8.3-intl

# Instalar Composer
cd ~
php -r "copy('https://getcomposer.org/installer', 'composer-setup.php');"
php composer-setup.php --install-dir=/usr/local/bin --filename=composer
rm composer-setup.php

# Instalar MySQL 8
sudo apt install -y mysql-server
sudo systemctl enable mysql
sudo systemctl start mysql

# Instalar Nginx
sudo apt install -y nginx
sudo systemctl enable nginx
sudo systemctl start nginx

# Instalar Node.js y npm
curl -fsSL https://deb.nodesource.com/setup_22.x | sudo -E bash -
sudo apt install -y nodejs

# Instalar pm2 globalmente (para Node.js)
sudo npm install -g pm2

# Mostrar versiones instaladas
echo "PHP version: $(php -v | head -n 1)"
echo "Composer version: $(composer --version)"
echo "MySQL version: $(mysql --version)"
echo "Nginx version: $(nginx -v 2>&1)"
echo "Node.js version: $(node -v)"
echo "PM2 version: $(pm2 -v)"

echo "¡Stack instalado!"
