<?php

namespace Modules\Domain\Modules\Auth\UseCases;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Shared\Utils\Response;
use Modules\Domain\Modules\Auth\Repositories\AuthRepository;

class AuthUseCases
{
    public static function login(Request $request)
    {
        try {
            $result = AuthRepository::login($request);
            return Response::success($result);
        } catch (Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public static function resetPassword(Request $request)
    {
        DB::beginTransaction();
        try {
            $result = AuthRepository::resetPassword($request);
            DB::commit();
            return Response::success($result);
        } catch (Exception $e) {
            DB::rollBack();
            return Response::error($e->getMessage());
        }
    }

    public static function checkResetPassword(Request $request)
    {
        try {
            $result = AuthRepository::checkResetPassword($request);
            return Response::success($result);
        } catch (Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public static function changePassword(Request $request)
    {
        DB::beginTransaction();
        try {
            $result = AuthRepository::changePassword($request);
            DB::commit();
            return Response::success($result);
        } catch (Exception $e) {
            DB::rollBack();
            return Response::error($e->getMessage());
        }
    }
}
