<?php

namespace Modules\Domain\Modules\Home\UseCases;

use Exception;
use Modules\Domain\Modules\Home\Repositories\HomeRepository;
use Modules\Shared\Helpers\SessionManager;
use Modules\Shared\Utils\Response;
use Modules\Domain\Modules\User\Models\User;

class HomeUseCases
{
    public static function home()
    {
        try {

            $session = SessionManager::get();
            $user = User::find($session->id);

            $result = HomeRepository::home($user);

            return Response::success($result);
        } catch (Exception $e) {
            return Response::error($e->getMessage());
        }
    }
}
