<?php

namespace Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Application\Requests\UpdateProfileCompanyRequest;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Application\UseCases\CompanyUseCase;

class CompanyController extends Controller
{
  public function list()
  {
    return CompanyUseCase::list();
  }
  public function profile(Request $request)
  {
    return CompanyUseCase::profile($request);
  }
  public function updateProfile(UpdateProfileCompanyRequest $request)
  {
    return CompanyUseCase::updateProfile($request->validated());
  }
  public function uploadLogo(Request $request)
  {
    return CompanyUseCase::uploadLogo($request);
  }
  public function deleteLogo()
  {
    return CompanyUseCase::deleteLogo();
  }
  public function verifyCompany($id)
  {
    return CompanyUseCase::verifyCompany($id);
  }

  public function unverifyCompany($id)
  {
    return CompanyUseCase::unverifyCompany($id);
  }
  public function deleteCompany($id)
  {
    return CompanyUseCase::deleteCompany($id);
  }
}
