<?php

namespace Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Application\Requests\CreateJobOfferRequest;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Application\UseCases\CreateJobOfferUseCase;

class CreateJobOfferController extends Controller
{
  public function __invoke(
    CreateJobOfferRequest $request,
    CreateJobOfferUseCase $useCase
  ): JsonResponse {
    $response = $useCase->execute($request->validated());
    return $response;
  }
}
