<?php

namespace Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Application\Requests\SearchJobOffersRequest;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Application\UseCases\SearchJobOffersUseCase;

class SearchJobOffersController extends Controller
{
  public function __invoke(
    SearchJobOffersRequest $request,
    SearchJobOffersUseCase $useCase
  ): JsonResponse {
    $response = $useCase->execute($request->validated());
    return $response;
  }
}
