<?php

namespace Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Application\Requests\CreateJobOfferRequest;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Application\UseCases\UpdateobOfferUseCase;

class UpdateJobOfferController extends Controller
{
  public function __invoke(
    int $id,
    CreateJobOfferRequest $request,
    UpdateobOfferUseCase $useCase
  ): JsonResponse {
    $response = $useCase->execute($id, $request->validated());
    return $response;
  }
}
