<?php

namespace Modules\Domain\Modules\User\Helpers;

use Modules\Domain\Modules\SystemConfiguration\Helpers\SystemConfigurationHelper;
use Modules\Domain\Modules\SystemConfiguration\Models\SystemConfiguration;
use Modules\Domain\Modules\User\Models\Menu;
use Modules\Domain\Modules\User\Models\Option;

class MenuHelper
{
    public static function listByUser($user)
    {
        $excluded_options = [];

        $menus = Menu::select('menu.id', 'menu.name')
            ->join('option', 'menu.id', 'option.menu_id')
            ->join('rol_option', 'option.id', 'rol_option.option_id')
            ->where('rol_option.rol_id', $user->rol_id)
            ->groupBy('menu.id', 'menu.name')
            ->get();

        $result = [];
        foreach ($menus as $menu) {
            $options = self::getOptions($user->rol_id, $menu->id, null, $excluded_options);
            if (count($options) == 0) continue;
            $menu->options = $options;
            $result[] = $menu;
        }

        return $result;
    }

    public static function getOptions($rol_id, $menu_id, $option_id, $excluded_options)
    {
        $options = Option::select([
            'option.id',
            'option.name',
            'option.name_url',
            'option.icon',
        ])
            ->join('rol_option', 'option.id', 'rol_option.option_id')
            ->where('option.menu_id', $menu_id)
            ->where('rol_option.rol_id', $rol_id)
            ->where('option.is_visible', true)
            ->where('option.option_id', $option_id)
            ->whereNotIn('option.name_url', $excluded_options)
            ->get();

        foreach ($options as $option) {
            $option->options = self::getOptions($rol_id, $menu_id, $option->id, $excluded_options);
        }

        return $options;
    }
}
