<?php

namespace Modules\Domain\Modules\User\Helpers;

use Exception;
use Modules\Shared\Helpers\SessionManager;
use Modules\Domain\Modules\User\Enums\RoleEnum;
use Modules\Domain\Modules\User\Models\User;

class RolHelper
{
    public static function validateTeacherAccess()
    {
        $session = SessionManager::get();

        $user = User::find($session->id);

        if ($user->rol_id != RoleEnum::TEACHER) {
            throw new Exception("No tienes permisos para realizar esta acción");
        }

        return $user;
    }

    public static function validateStudentAccess()
    {
        $session = SessionManager::get();

        $user = User::find($session->id);

        if ($user->rol_id != RoleEnum::STUDENT) {
            throw new Exception("No tienes permisos para realizar esta acción");
        }

        return $user;
    }

    public static function validateAdminAccess()
    {
        $session = SessionManager::get();

        $user = User::find($session->id);

        if ($user->rol_id != RoleEnum::ADMINISTRADOR) {
            throw new Exception("No tienes permisos para realizar esta acción");
        }

        return $user;
    }
}
