<?php

namespace Modules\Domain\Modules\User\Models;

use Exception;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Domain\Modules\User\Models\AditionalData;
use Modules\Domain\Modules\User\Models\SchoolData;
use Modules\Domain\Modules\User\Models\Family;

class Person extends Model
{
    use SoftDeletes;

    protected $table = 'person';

    protected $fillable = [
        'document_type',
        'document_number',
        'names',
        'phone',
        'email',
        'sex',
        'birth_date',
        'native_language',
    ];

    public function user(): HasOne
    {
        return $this->hasOne(User::class);
    }


    public function aditionalData(): HasOne
    {
        return $this->hasOne(AditionalData::class);
    }

    public function schoolData(): HasOne
    {
        return $this->hasOne(SchoolData::class);
    }

    public function family(): HasOne
    {
        return $this->hasOne(Family::class);
    }
    public function scopeByKey($query, $key, $value)
    {
        $result = $query->where($key, $value)->first();

        if (!$result) {
            throw new Exception('Persona no encontrada');
        }

        return $result;
    }
}
