<?php

use Illuminate\Support\Facades\Route;
use Modules\Domain\Modules\Auth\Controllers\AuthController;
use Modules\Domain\Modules\File\Controllers\FileController;
use Modules\Domain\Modules\File\Controllers\LinkController;
use Modules\Domain\Modules\Home\Controllers\HomeController;
use Modules\Domain\Modules\JobOpportunities\Company\Interfaces\Http\Controllers\RegisterCompanyController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\JobOfferFiltersController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\SearchJobOffersController;
use Modules\Domain\Modules\SystemConfiguration\Controllers\SystemConfigurationController;
use Modules\Domain\Modules\Testing\TestingController;
use Modules\Domain\Modules\User\Controllers\MenuController;
use Modules\Domain\Modules\User\Controllers\ProfileController;
use Modules\Domain\Modules\User\Controllers\RolController;
use Modules\Domain\Modules\User\Controllers\UserController;
use Modules\Domain\Middleware\AuthTenantMiddleware;
use Modules\Domain\Modules\JobOpportunities\Applicants\Controllers\ApplicantController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\ChangeOfferStatusController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\CompanyController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\CreateJobOfferController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\DeleteJobOfferController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\FindJobOfferController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\PublicJobOffersController;
use Modules\Domain\Modules\JobOpportunities\JobOffer\Interfaces\Http\Controllers\UpdateJobOfferController;
use Modules\Domain\Modules\JobOpportunities\MasterTable\Controllers\MasterTableController;

#rutas publicas
Route::controller(SystemConfigurationController::class)
    ->prefix('system_configuration')
    ->group(function () {
        Route::get('general', 'general');
        Route::get('landing_page', 'landingPage');
    });

Route::controller(AuthController::class)
    ->prefix('auth')
    ->group(function () {
        Route::post('login', 'login');
        Route::put('reset/password', 'resetPassword');
        Route::get('check/reset/password', 'checkResetPassword');
        Route::put('change/password', 'changePassword');
    });

Route::prefix('job-opportunities')
    ->group(function () {
        Route::prefix('public')->group(function () {
            Route::prefix('companies')->group(function () {
                Route::post('register', [RegisterCompanyController::class, '__invoke']);
                Route::get('', [CompanyController::class, 'list']);
            });
            Route::prefix('offers')
                ->group(function () {
                    Route::get('filters', [PublicJobOffersController::class, 'filters']);
                    Route::post('list', [PublicJobOffersController::class, 'list']);
                    Route::get('slug/{slug}', [PublicJobOffersController::class, 'findSlug']);
                });
        });
    });

Route::controller(TestingController::class)
    ->prefix('testing')
    ->group(function () {
        Route::get('', 'test');
    });

#rutas privadas
Route::group(['middleware' => [
    AuthTenantMiddleware::class,
]], function () {
    Route::controller(RolController::class)
        ->prefix('rol')
        ->group(function () {
            Route::get('list', 'list');
            Route::put('change/{id}', 'change');
        });

    Route::controller(MenuController::class)
        ->prefix('menu')
        ->group(function () {
            Route::get('', 'get');
        });

    Route::controller(ProfileController::class)
        ->prefix('profile')
        ->group(function () {
            Route::get('', 'get');
        });

    Route::controller(UserController::class)
        ->prefix('user')
        ->group(function () {
            Route::get('params', 'params');
            Route::post('list', 'list');
            Route::post('create', 'create');
            Route::put('update/{id}', 'update');
            Route::put('change/password/{id}', 'changePassword');
            Route::post('change/photo/{id}', 'changePhoto');
            Route::delete('delete/photo/{id}', 'deletePhoto');
            Route::put('reset/password/{id}', 'resetPassword');
            Route::put('disable/{id}', 'disable');
            Route::delete('delete/{id}', 'delete');
            Route::post('import', 'import');
        });

    Route::controller(HomeController::class)
        ->prefix('home')
        ->group(function () {
            Route::get('', 'home');
        });

    Route::controller(FileController::class)
        ->prefix('file')
        ->group(function () {
            Route::get('download/{uuid}', 'download');
            Route::post('upload', 'upload');
            Route::delete('delete/{id}/{model}', 'delete');
        });

    Route::controller(LinkController::class)
        ->prefix('link')
        ->group(function () {
            Route::post('create', 'create');
            Route::delete('delete/{id}/{model}', 'delete');
        });


    Route::controller(SystemConfigurationController::class)
        ->prefix('system_configuration')
        ->group(function () {
            Route::get('list', 'list');
            Route::post('update/{key}', 'update');
            Route::post('upload/image', 'uploadImage');
            Route::delete('delete/image', 'deleteImage');
        });

    Route::controller(SystemConfigurationController::class)
        ->prefix('system_configuration')
        ->group(function () {
            Route::get('list', 'list');
            Route::post('update/{key}', 'update');
            Route::post('upload/image', 'uploadImage');
            Route::delete('delete/image', 'deleteImage');
        });

    Route::prefix('job-opportunities')
        ->group(function () {
            Route::prefix('offers')
                ->group(function () {
                    Route::get('filters', [JobOfferFiltersController::class, '__invoke']);
                    Route::post('list', [SearchJobOffersController::class, '__invoke']);
                    Route::post('create', [CreateJobOfferController::class, '__invoke']);
                    Route::get('find', [FindJobOfferController::class, '__invoke']);
                    Route::put('update/{id}', [UpdateJobOfferController::class, '__invoke']);
                    Route::delete('delete/{id}', [DeleteJobOfferController::class, '__invoke']);
                    Route::put('change-state', ChangeOfferStatusController::class);
                });
        })->group(function () {
            Route::controller(ApplicantController::class)
                ->prefix('applicants')
                ->group(function () {
                    Route::get('check-offer/{slug}', 'checkOffer');
                    Route::post('upload-cv', 'uploadCV');
                    Route::post('apply-offer', 'applyOffer');
                    Route::get('my-applications', 'myApplications');
                    Route::delete('cancel/{id}', 'cancelApplication');
                    Route::get('my-cvs', 'myCvs');
                    Route::delete('my-cvs/{id}', 'deleteMyCv');
                    Route::get('by-offer/filters', 'applicationsByOfferFilters');
                    Route::get('by-offer', 'applicationsByOffer');
                    Route::put('set-state/{id}', 'setState');
                });
        })->group(function () {
            Route::controller(CompanyController::class)
                ->prefix('companies')
                ->group(function () {
                    Route::get('', 'list');
                    Route::get('profile', 'profile');
                    Route::put('profile', 'updateProfile');
                    Route::post('upload-logo', 'uploadLogo');
                    Route::delete('delete-logo', 'deleteLogo');
                    Route::put('verify/{id}', 'verifyCompany');
                    Route::put('unverify/{id}', 'unverifyCompany');
                    Route::delete('delete/{id}', 'deleteCompany');
                });
        })->group(function () {
            Route::controller(MasterTableController::class)
                ->prefix('master-table')
                ->group(function () {
                    Route::get('{table}', 'index');
                    Route::post('{table}', 'store');
                    Route::put('{table}/{id}', 'update');
                    Route::delete('{table}/{id}', 'destroy');
                });
        });
});
